/*!
 * Chat Relay v7.2.0
 * (c) 2026 Edgely. All rights reserved.
 * License: Proprietary / Commercial
*/
 
document.addEventListener('DOMContentLoaded', function() {
    
    if (typeof chatRelayData === 'undefined') return;

    const { phone, brand, welcome, question, pageTitle } = chatRelayData;

    const input = document.getElementById('chat-relay-input-field'); 
    const sendBtn = document.getElementById('chat-relay-send-btn');

    // Inject Text Content
    const msg1 = document.querySelector('#chat-relay-msg-1 .chat-relay-bubble');
    const msg2 = document.querySelector('#chat-relay-msg-2 .chat-relay-bubble');

    if (msg1) msg1.innerText = welcome;
    if (msg2) msg2.innerText = question;

    // Toggle Function
    window.toggleChatRelay = function() {
        const win = document.getElementById('chat-relay-window');
        const btn = document.getElementById('chat-relay-trigger-btn');
        const backdrop = document.getElementById('chat-relay-backdrop');
        const isOpen = win.classList.contains('show');

        if (!isOpen) {
            win.style.display = 'flex'; 
            backdrop.style.display = 'block'; 
            btn.classList.add('is-open');
            win.setAttribute('aria-hidden', 'false');
            
            setTimeout(() => { 
                win.classList.add('show'); 
                if (window.innerWidth <= 600) backdrop.classList.add('show'); 
            }, 10);
            
            runSequenceRelay();
        } else {
            win.classList.remove('show'); 
            backdrop.classList.remove('show'); 
            btn.classList.remove('is-open');
            win.setAttribute('aria-hidden', 'true');

            setTimeout(() => { 
                win.style.display = 'none'; 
                backdrop.style.display = 'none'; 
            }, 300);
        }
    };

    let hasRunRelay = false;
    function runSequenceRelay() {
        if(hasRunRelay) return;
        const typing = document.getElementById('chat-relay-typing');
        const msg2Row = document.getElementById('chat-relay-msg-2');
        
        setTimeout(() => { typing.style.display = 'block'; }, 600);
        setTimeout(() => { 
            typing.style.display = 'none'; 
            msg2Row.style.display = 'flex'; 
            hasRunRelay = true; 
        }, 2200);
    }

    // Define the send logic
    const performSend = function() {
        // Safety check to ensure input exists
        if (!input) {
            console.error('Chat Relay: Input element not found.');
            return;
        }

        const userMsg = input.value.trim();

        if (userMsg) {
            const context = `${userMsg}\n\n—\nRef: ${pageTitle}`;
            const url = `https://wa.me/${phone}?text=${encodeURIComponent(context)}`;
            
            window.open(url, '_blank');
            input.value = ''; 
        }
    };

    if (sendBtn) {
        sendBtn.addEventListener('click', performSend);
    }

    if (input) {
        input.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault(); // Prevents new line in textarea if applicable
                performSend();
            }
        });
    }
});
